/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.ICombinedAttribute;
import dev.toma.gunsrpg.common.attribute.Attribute;
import dev.toma.gunsrpg.common.attribute.AttributeId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public final class Attribs {
    public static final Codec<IAttributeId> LOOKUP_CODEC = ResourceLocation.field_240908_a_.comapFlatMap(location -> {
        IAttributeId id = Attribs.find(location);
        return id != null ? DataResult.success((Object)id) : DataResult.error((String)("Unknown attribute: " + location));
    }, IAttributeId::getId);
    private static final Map<ResourceLocation, IAttributeId> KEY_MAP = new HashMap<ResourceLocation, IAttributeId>();
    public static final IAttributeId GUNPOWDER_OUTPUT = Attribs.createInternal("gunpowder_out", 0.0);
    public static final IAttributeId BONEMEAL_OUTPUT = Attribs.createInternal("bonemeal_out", 0.0);
    public static final IAttributeId BLAZEPOWDER_OUTPUT = Attribs.createInternal("blazepowder_out", 0.0);
    public static final IAttributeId AMMO_OUTPUT = Attribs.createInternal("ammo_output", 0.0);
    public static final IAttributeId QUEST_AMMO = Attribs.createInternal("quests_ammo");
    public static final IAttributeId QUEST_EXPLOSIVES = Attribs.createInternal("quests_explosives");
    public static final IAttributeId QUEST_VISIBLE_REWARD = Attribs.createInternal("quests_visible_reward", 3.0);
    public static final IAttributeId QUEST_MEDS = Attribs.createInternal("quests_meds", 0.0);
    public static final IAttributeId QUEST_ORBS = Attribs.createInternal("quests_orbs", 0.0);
    public static final IAttributeId QUEST_PERKBOOK = Attribs.createInternal("quests_perkbook", 0.0);
    public static final IAttributeId QUEST_FLARE = Attribs.createInternal("quests_flare", 0.0);
    public static final IAttributeId ADRENALINE_EFFECT = Attribs.createInternal("adrenaline_effect");
    public static final IAttributeId MORPHINE_EFFECT = Attribs.createInternal("morphine_effect");
    public static final IAttributeId STEROIDS_EFFECT = Attribs.createInternal("steroids_effect");
    public static final IAttributeId ANTIDOTE_EFFECT = Attribs.createInternal("antidote_effect", 40.0);
    public static final IAttributeId VACCINE_EFFECT = Attribs.createInternal("vaccine_effect", 50.0);
    public static final IAttributeId SPLINT_EFFECT = Attribs.createInternal("splint_effect", 35.0);
    public static final IAttributeId BANDAGE_EFFECT = Attribs.createInternal("bandage_effect", 25.0);
    public static final IAttributeId HEMOSTAT_EFFECT = Attribs.createInternal("hemostat_effect", 1200.0);
    public static final IAttributeId HEMOSTAT_EFFECTIVENESS = Attribs.createInternal("hemostat_effectiveness", 0.5);
    public static final IAttributeId CALCIUM_SHOT_EFFECT = Attribs.createInternal("calcium_shot_effect", 1200.0);
    public static final IAttributeId CALCIUM_SHOT_EFFECTIVENES = Attribs.createInternal("calcium_shot_effectiveness", 0.5);
    public static final IAttributeId VITAMINS_EFFECT = Attribs.createInternal("vitamins_effect", 1200.0);
    public static final IAttributeId VITAMINS_EFFECTIVENESS = Attribs.createInternal("vitamins_effectiveness", 0.5);
    public static final IAttributeId PROPITAL_EFFECT = Attribs.createInternal("propital_effect", 1200.0);
    public static final IAttributeId PROPITAL_EFFECTIVENESS = Attribs.createInternal("propital_effectiveness", 0.5);
    public static final IAttributeId POISON_RESISTANCE = Attribs.createInternal("poison_resistance", 0.0);
    public static final IAttributeId POISON_DELAY = Attribs.createInternal("poison_delay", 140.0);
    public static final IAttributeId POISON_BLOCK = Attribs.createInternal("poison_block", 0.0);
    public static final IAttributeId INFECTION_RESISTANCE = Attribs.createInternal("infection_resistance", 0.0);
    public static final IAttributeId INFECTION_DELAY = Attribs.createInternal("infection_delay", 200.0);
    public static final IAttributeId INFECTION_BLOCK = Attribs.createInternal("infection_block", 0.0);
    public static final IAttributeId FRACTURE_RESISTANCE = Attribs.createInternal("fracture_resistance", 0.0);
    public static final IAttributeId FRACTURE_DELAY = Attribs.createInternal("fracture_delay", 240.0);
    public static final IAttributeId FRACTURE_BLOCK = Attribs.createInternal("fracture_block", 0.0);
    public static final IAttributeId BLEED_RESISTANCE = Attribs.createInternal("bleed_resistance", 0.0);
    public static final IAttributeId BLEED_DELAY = Attribs.createInternal("bleed_delay", 120.0);
    public static final IAttributeId BLEED_BLOCK = Attribs.createInternal("bleed_block", 0.0);
    public static final IAttributeId EXPLOSION_RESISTANCE = Attribs.createInternal("explosion_resistance", 0.0);
    public static final IAttributeId FALL_RESISTANCE = Attribs.createInternal("fall_resistance");
    public static final IAttributeId MELEE_DAMAGE = Attribs.createInternal("melee_damage", 0.0);
    public static final IAttributeId MELEE_COOLDOWN = Attribs.createInternal("melee_cooldown");
    public static final IAttributeId BOW_DAMAGE = Attribs.createInternal("bow_damage");
    public static final IAttributeId PISTOL_DAMAGE = Attribs.createInternal("pistol_damage");
    public static final IAttributeId SMG_DAMAGE = Attribs.createInternal("smg_damage");
    public static final IAttributeId SHOTGUN_DAMAGE = Attribs.createInternal("shotgun_damage");
    public static final IAttributeId AR_DAMAGE = Attribs.createInternal("ar_damage");
    public static final IAttributeId DMR_DAMAGE = Attribs.createInternal("dmr_damage");
    public static final IAttributeId SR_DAMAGE = Attribs.createInternal("sr_damage");
    public static final IAttributeId SILENT_WEAPON_DAMAGE = Attribs.createInternal("silent_weapon_damage");
    public static final IAttributeId LOUD_WEAPON_DAMAGE = Attribs.createInternal("loud_weapon_damage");
    public static final IAttributeId HEADSHOT_DAMAGE = Attribs.createInternal("headshot_damage");
    public static final IAttributeId RECOIL_CONTROL = Attribs.createInternal("recoil_control");
    public static final IAttributeId RELOAD_SPEED = Attribs.createInternal("reload_speed");
    public static final IAttributeId WEAPON_DURABILITY = Attribs.createInternal("weapon_durability");
    public static final IAttributeId JAM_CHANCE = Attribs.createInternal("weapon_jamming");
    public static final IAttributeId WEAPON_NOISE = Attribs.createInternal("weapon_noise");
    public static final IAttributeId UNJAMMING_SPEED = Attribs.createInternal("unjamming_speed");
    public static final IAttributeId REPAIR_PENALTY = Attribs.createInternal("repair_penalty", 0.7);
    public static final IAttributeId HEAL_BOOST = Attribs.createInternal("heal_boost", 0.0);
    public static final IAttributeId DAMAGE_TAKEN = Attribs.createInternal("damage_taken");
    public static final IAttributeId FALL_DAMAGE = Attribs.createInternal("fall_damage");
    public static final IAttributeId DIGGING_SPEED = Attribs.createInternal("digging_speed");
    public static final IAttributeId MINING_SPEED = Attribs.createInternal("mining_speed");
    public static final IAttributeId WOODCUTTING_SPEED = Attribs.createInternal("woodcutting_speed");
    public static final IAttributeId MOVEMENT_SPEED = Attribs.createInternal("movement_speed");
    public static final IAttributeId PERK_BOOK_CHANCE = Attribs.createInternal("perk_book_chance");
    public static final IAttributeId SKILL_BOOK_CHANCE = Attribs.createInternal("skill_book_chance");
    public static final IAttributeId INSTANT_KILL = Attribs.createInternal("instant_kill", 0.0);
    public static final IAttributeId LIKE_A_CAT_EFFECT = Attribs.createInternal("like_a_cat_effect");
    public static final IAttributeId AIRDROP_CALL_COOLDOWN = Attribs.createInternal("airdrop_call_cooldown");
    public static final IAttributeId SECOND_CHANCE_COOLDOWN = Attribs.createInternal("second_chance_cooldown");
    public static final IAttributeId WELL_FED_DURATION = Attribs.createInternal("well_fed_duration");
    public static final IAttributeId MOTHERLODE_BONUS = Attribs.createInternal("motherlode_bonus");
    public static final IAttributeId IRON_BUDDY_COOLDOWN = Attribs.createInternal("iron_buddy_cooldown");
    public static final IAttributeId M1911_RELOAD_SPEED = Attribs.createInternal("m1911_reload_speed", 45.0);
    public static final IAttributeId M1911_MAG_CAPACITY = Attribs.createInternal("m1911_mag_capacity", 7.0);
    public static final IAttributeId M1911_FIRERATE = Attribs.createInternal("m1911_firerate", 4.0);
    public static final IAttributeId M1911_HORIZONTAL_RECOIL = Attribs.createInternal("m1911_horizontal_recoil", 1.4);
    public static final IAttributeId M1911_VERTICAL_RECOIL = Attribs.createInternal("m1911_vertical_recoil", 3.1);
    public static final IAttributeId M1911_NOISE = Attribs.createInternal("m1911_noise");
    public static final IAttributeId R45_FAST_HANDS = Attribs.createInternal("r45_fast_hands", 17.0);
    public static final IAttributeId R45_VERTICAL_RECOIL = Attribs.createInternal("r45_vertical_recoil", 4.5);
    public static final IAttributeId R45_HORIZONTAL_RECOIL = Attribs.createInternal("r45_horizontal_recoil", 1.8);
    public static final IAttributeId R45_MAG_CAPACITY = Attribs.createInternal("r45_mag_capacity", 6.0);
    public static final IAttributeId R45_FIRERATE = Attribs.createInternal("r45_firerate", 15.0);
    public static final IAttributeId R45_NOISE = Attribs.createInternal("r45_noise");
    public static final IAttributeId DEAGLE_RELOADING = Attribs.createInternal("deagle_reloading", 60.0);
    public static final IAttributeId DEAGLE_FIRERATE = Attribs.createInternal("deagle_firerate", 8.0);
    public static final IAttributeId DEAGLE_HORIZONTAL_RECOIL = Attribs.createInternal("deagle_horizontal_recoil", 2.0);
    public static final IAttributeId DEAGLE_VERTICAL_RECOIL = Attribs.createInternal("deagle_vertical_recoil", 4.4);
    public static final IAttributeId DEAGLE_MAG_CAPACITY = Attribs.createInternal("deagle_mag_capacity", 7.0);
    public static final IAttributeId UMP45_RELOAD_SPEED = Attribs.createInternal("ump45_reload_speed", 60.0);
    public static final IAttributeId UMP45_MAG_CAPACITY = Attribs.createInternal("ump45_mag_capacity", 25.0);
    public static final IAttributeId UMP45_VERTICAL_RECOIL = Attribs.createInternal("ump45_vertical_recoil", 2.1);
    public static final IAttributeId UMP45_FIRERATE = Attribs.createInternal("ump45_firerate", 3.0);
    public static final IAttributeId UMP45_NOISE = Attribs.createInternal("ump45_noise");
    public static final IAttributeId THOMPSON_RELOAD_SPEED = Attribs.createInternal("thompson_reload_speed", 75.0);
    public static final IAttributeId THOMPSON_MAG_CAPACITY = Attribs.createInternal("thompson_mag_capacity", 30.0);
    public static final IAttributeId THOMPSON_VERTICAL_RECOIL = Attribs.createInternal("thompson_vertical_recoil", 2.6);
    public static final IAttributeId THOMPSON_FIRERATE = Attribs.createInternal("thompson_firerate", 3.0);
    public static final IAttributeId THOMPSON_NOISE = Attribs.createInternal("thompson_noise");
    public static final IAttributeId VECTOR_RELOAD_SPEED = Attribs.createInternal("vector_reload_speed", 70.0);
    public static final IAttributeId VECTOR_VERTICAL_RECOIL = Attribs.createInternal("vector_vertical_recoil", 1.7);
    public static final IAttributeId VECTOR_MAG_CAPACITY = Attribs.createInternal("vector_mag_capacity", 17.0);
    public static final IAttributeId VECTOR_LOUDNESS = Attribs.createInternal("vector_loudness");
    public static final IAttributeId CROSSBOW_RELOAD_SPEED = Attribs.createInternal("crossbow_reload_speed", 60.0);
    public static final IAttributeId CROSSBOW_MAG_CAPACITY = Attribs.createInternal("crossbow_mag_capacity");
    public static final IAttributeId CHUKONU_RELOAD_SPEED = Attribs.createInternal("chukonu_reload_speed", 22.0);
    public static final IAttributeId CHUKONU_MAG_CAPACITY = Attribs.createInternal("chukonu_mag_capacity", 6.0);
    public static final IAttributeId CHUKONU_FIRERATE = Attribs.createInternal("chukonu_firerate", 5.0);
    public static final IAttributeId S1897_RELOAD_SPEED = Attribs.createInternal("s1897_reload_speed", 22.0);
    public static final IAttributeId S1897_MAG_CAPACITY = Attribs.createInternal("s1897_mag_capacity", 5.0);
    public static final IAttributeId S1897_FIRERATE = Attribs.createInternal("s1897_firerate", 25.0);
    public static final IAttributeId S686_RELOAD_SPEED = Attribs.createInternal("s686_reload_speed", 70.0);
    public static final IAttributeId S12K_RELOAD_SPEED = Attribs.createInternal("s12k_reload_speed", 80.0);
    public static final IAttributeId S12K_MAG_CAPACITY = Attribs.createInternal("s12k_mag_capacity", 5.0);
    public static final IAttributeId S12K_VERTICAL_RECOIL = Attribs.createInternal("s12k_vertical_recoil", 4.2);
    public static final IAttributeId S12K_HORIZONTAL_RECOIL = Attribs.createInternal("s12k_horizontal_recoil", 2.2);
    public static final IAttributeId S12K_FIRERATE = Attribs.createInternal("s12k_firerate", 10.0);
    public static final IAttributeId S12K_LOUDNESS = Attribs.createInternal("s12k_loudness");
    public static final IAttributeId AKM_RELOAD_SPEED = Attribs.createInternal("akm_reload_speed", 75.0);
    public static final IAttributeId AKM_MAG_CAPACITY = Attribs.createInternal("akm_mag_capacity", 30.0);
    public static final IAttributeId AKM_LOUDNESS = Attribs.createInternal("akm_loudness");
    public static final IAttributeId AKM_FIRERATE = Attribs.createInternal("akm_firerate", 3.0);
    public static final IAttributeId HK416_RELOAD_SPEED = Attribs.createInternal("hk416_reload_speed", 70.0);
    public static final IAttributeId HK416_VERTICAL_RECOIL = Attribs.createInternal("hk416_vertical_recoil", 2.6);
    public static final IAttributeId HK416_HORIZONTAL_RECOIL = Attribs.createInternal("hk416_horizontal_recoil", 1.4);
    public static final IAttributeId HK416_MAG_CAPACITY = Attribs.createInternal("hk416_mag_capacity", 30.0);
    public static final IAttributeId HK416_LOUDNESS = Attribs.createInternal("hk416_loudness");
    public static final IAttributeId AUG_RELOAD_SPEED = Attribs.createInternal("aug_reload_speed", 75.0);
    public static final IAttributeId AUG_MAG_CAPACITY = Attribs.createInternal("aug_mag_capacity", 30.0);
    public static final IAttributeId AUG_VERTICAL_RECOIL = Attribs.createInternal("aug_vertical_recoil", 2.7);
    public static final IAttributeId AUG_HORIZONTAL_RECOIL = Attribs.createInternal("aug_horizontal_recoil", 0.6);
    public static final IAttributeId AUG_LOUDNESS = Attribs.createInternal("aug_loudness");
    public static final IAttributeId SKS_FIRERATE = Attribs.createInternal("sks_firerate", 7.0);
    public static final IAttributeId SKS_VERTICAL_RECOIL = Attribs.createInternal("sks_vertical_recoil", 4.7);
    public static final IAttributeId SKS_HORIZONTAL_RECOIL = Attribs.createInternal("sks_horizontal_recoil", 1.3);
    public static final IAttributeId SKS_MAG_CAPACITY = Attribs.createInternal("sks_mag_capacity", 10.0);
    public static final IAttributeId SKS_NOISE = Attribs.createInternal("sks_noise");
    public static final IAttributeId VSS_RELOAD_SPEED = Attribs.createInternal("vss_reload_speed", 75.0);
    public static final IAttributeId VSS_MAG_CAPACITY = Attribs.createInternal("vss_mag_capacity", 10.0);
    public static final IAttributeId VSS_VERTICAL_RECOIL = Attribs.createInternal("vss_vertical_recoil", 3.6);
    public static final IAttributeId VSS_HORIZONTAL_RECOIL = Attribs.createInternal("vss_horizontal_recoil", 1.7);
    public static final IAttributeId VSS_FIRERATE = Attribs.createInternal("vss_firerate", 3.0);
    public static final IAttributeId MK14_RELOAD_SPEED = Attribs.createInternal("mk14_reload_speed", 75.0);
    public static final IAttributeId MK14_VERTICAL_RECOIL = Attribs.createInternal("mk14_vertical_recoil", 3.9);
    public static final IAttributeId MK14_HORIZONTAL_RECOIL = Attribs.createInternal("mk14_horizontal_recoil", 2.0);
    public static final IAttributeId MK14_MAG_CAPACITY = Attribs.createInternal("mk14_mag_capacity", 10.0);
    public static final IAttributeId MK14_FIRERATE = Attribs.createInternal("mk14_firerate", 3.0);
    public static final IAttributeId MK14_LOUDNESS = Attribs.createInternal("mk14_loudness");
    public static final IAttributeId MK14_HS_DAMAGE = Attribs.createInternal("mk14_hs_damage");
    public static final IAttributeId KAR98K_VERTICAL_RECOIL = Attribs.createInternal("kar98k_vertical_recoil", 8.0);
    public static final IAttributeId KAR98K_HORIZONTAL_RECOIL = Attribs.createInternal("kar98k_horizontal_recoil", 0.9);
    public static final IAttributeId KAR98K_MAG_CAPACITY = Attribs.createInternal("kar98k_mag_capacity", 5.0);
    public static final IAttributeId KAR98K_RELOAD_SPEED = Attribs.createInternal("kar98k_reload_speed", 30.0);
    public static final IAttributeId KAR98K_NOISE = Attribs.createInternal("kar98k_noise");
    public static final IAttributeId KAR98K_FIRERATE = Attribs.createInternal("kar98k_firerate", 40.0);
    public static final IAttributeId KAR98K_HS_DAMAGE = Attribs.createInternal("kar98k_hs_damage");
    public static final IAttributeId WINCHESTER_RELOAD_SPEED = Attribs.createInternal("winchester_reload_speed", 25.0);
    public static final IAttributeId WINCHESTER_MAG_CAPACITY = Attribs.createInternal("winchester_mag_capacity", 8.0);
    public static final IAttributeId WINCHESTER_FIRERATE = Attribs.createInternal("winchester_firerate", 25.0);
    public static final IAttributeId AWM_RELOAD_SPEED = Attribs.createInternal("awm_reload_speed", 100.0);
    public static final IAttributeId AWM_MAG_CAPACITY = Attribs.createInternal("awm_mag_capacity", 5.0);
    public static final IAttributeId AWM_VERTICAL_RECOIL = Attribs.createInternal("awm_vertical_recoil", 5.5);
    public static final IAttributeId AWM_HORIZONTAL_RECOIL = Attribs.createInternal("awm_horizontal_recoil", 3.3f);
    public static final IAttributeId AWM_LOUDNESS = Attribs.createInternal("awm_loudness");
    public static final IAttributeId AWM_FIRERATE = Attribs.createInternal("awm_firerate", 36.0);
    public static final IAttributeId AWM_HS_DAMAGE = Attribs.createInternal("awm_hs_damage");
    public static final IAttributeId GL_RELOAD_SPEED = Attribs.createInternal("gl_reload_speed", 20.0);
    public static final IAttributeId GL_FIRERATE = Attribs.createInternal("gl_firerate", 15.0);
    public static final IAttributeId GL_MAG_CAPACITY = Attribs.createInternal("gl_mag_capacity", 4.0);
    public static final IAttributeId RL_RELOAD_SPEED = Attribs.createInternal("rl_reload_speed", 35.0);
    public static final ICombinedAttribute M1911_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, M1911_RELOAD_SPEED);
    public static final ICombinedAttribute M1911_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, M1911_VERTICAL_RECOIL);
    public static final ICombinedAttribute M1911_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, M1911_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute M1911_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, M1911_NOISE);
    public static final ICombinedAttribute R45_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, R45_FAST_HANDS);
    public static final ICombinedAttribute R45_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, R45_VERTICAL_RECOIL);
    public static final ICombinedAttribute R45_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, R45_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute R45_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, R45_NOISE);
    public static final ICombinedAttribute DEAGLE_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, DEAGLE_RELOADING);
    public static final ICombinedAttribute DEAGLE_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, DEAGLE_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute DEAGLE_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, DEAGLE_VERTICAL_RECOIL);
    public static final ICombinedAttribute UMP45_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, UMP45_RELOAD_SPEED);
    public static final ICombinedAttribute UMP45_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, UMP45_VERTICAL_RECOIL);
    public static final ICombinedAttribute UMP45_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, UMP45_NOISE);
    public static final ICombinedAttribute THOMPSON_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, THOMPSON_RELOAD_SPEED);
    public static final ICombinedAttribute THOMPSON_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, THOMPSON_VERTICAL_RECOIL);
    public static final ICombinedAttribute THOMPSON_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, THOMPSON_NOISE);
    public static final ICombinedAttribute VECTOR_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, VECTOR_RELOAD_SPEED);
    public static final ICombinedAttribute VECTOR_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, VECTOR_VERTICAL_RECOIL);
    public static final ICombinedAttribute VECTOR_NOISE = ICombinedAttribute.of(WEAPON_NOISE, VECTOR_LOUDNESS);
    public static final ICombinedAttribute CROSSBOW_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, CROSSBOW_RELOAD_SPEED);
    public static final ICombinedAttribute CHUKONU_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, CHUKONU_RELOAD_SPEED);
    public static final ICombinedAttribute S1897_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, S1897_RELOAD_SPEED);
    public static final ICombinedAttribute S686_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, S686_RELOAD_SPEED);
    public static final ICombinedAttribute S12K_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, S12K_RELOAD_SPEED);
    public static final ICombinedAttribute S12K_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, S12K_VERTICAL_RECOIL);
    public static final ICombinedAttribute S12K_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, S12K_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute S12K_NOISE = ICombinedAttribute.of(WEAPON_NOISE, S12K_LOUDNESS);
    public static final ICombinedAttribute AKM_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, AKM_RELOAD_SPEED);
    public static final ICombinedAttribute AKM_NOISE = ICombinedAttribute.of(WEAPON_NOISE, AKM_LOUDNESS);
    public static final ICombinedAttribute HK416_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, HK416_RELOAD_SPEED);
    public static final ICombinedAttribute HK416_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, HK416_VERTICAL_RECOIL);
    public static final ICombinedAttribute HK416_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, HK416_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute HK416_NOISE = ICombinedAttribute.of(WEAPON_NOISE, HK416_LOUDNESS);
    public static final ICombinedAttribute AUG_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, AUG_RELOAD_SPEED);
    public static final ICombinedAttribute AUG_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, AUG_VERTICAL_RECOIL);
    public static final ICombinedAttribute AUG_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, AUG_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute AUG_NOISE = ICombinedAttribute.of(WEAPON_NOISE, AUG_LOUDNESS);
    public static final ICombinedAttribute SKS_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, SKS_VERTICAL_RECOIL);
    public static final ICombinedAttribute SKS_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, SKS_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute SKS_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, SKS_NOISE);
    public static final ICombinedAttribute VSS_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, VSS_RELOAD_SPEED);
    public static final ICombinedAttribute VSS_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, VSS_VERTICAL_RECOIL);
    public static final ICombinedAttribute VSS_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, VSS_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute MK14_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, MK14_RELOAD_SPEED);
    public static final ICombinedAttribute MK14_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, MK14_VERTICAL_RECOIL);
    public static final ICombinedAttribute MK14_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, MK14_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute MK14_NOISE = ICombinedAttribute.of(WEAPON_NOISE, MK14_LOUDNESS);
    public static final ICombinedAttribute MK14_HEADSHOT = ICombinedAttribute.of(HEADSHOT_DAMAGE, MK14_HS_DAMAGE);
    public static final ICombinedAttribute KAR98K_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, KAR98K_RELOAD_SPEED);
    public static final ICombinedAttribute KAR98K_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, KAR98K_VERTICAL_RECOIL);
    public static final ICombinedAttribute KAR98K_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, KAR98K_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute KAR98K_LOUDNESS = ICombinedAttribute.of(WEAPON_NOISE, KAR98K_NOISE);
    public static final ICombinedAttribute KAR98K_HEADSHOT = ICombinedAttribute.of(HEADSHOT_DAMAGE, KAR98K_HS_DAMAGE);
    public static final ICombinedAttribute WINCHESTER_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, WINCHESTER_RELOAD_SPEED);
    public static final ICombinedAttribute AWM_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, AWM_RELOAD_SPEED);
    public static final ICombinedAttribute AWM_VERTICAL = ICombinedAttribute.of(RECOIL_CONTROL, AWM_VERTICAL_RECOIL);
    public static final ICombinedAttribute AWM_HORIZONTAL = ICombinedAttribute.of(RECOIL_CONTROL, AWM_HORIZONTAL_RECOIL);
    public static final ICombinedAttribute AWM_NOISE = ICombinedAttribute.of(WEAPON_NOISE, AWM_LOUDNESS);
    public static final ICombinedAttribute AWM_HEADSHOT = ICombinedAttribute.of(HEADSHOT_DAMAGE, AWM_HS_DAMAGE);
    public static final ICombinedAttribute GL_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, GL_RELOAD_SPEED);
    public static final ICombinedAttribute RL_RELOAD = ICombinedAttribute.of(RELOAD_SPEED, RL_RELOAD_SPEED);

    public static IAttributeId find(ResourceLocation id) {
        return KEY_MAP.get(id);
    }

    public static Set<ResourceLocation> listKeys() {
        return Collections.unmodifiableSet(KEY_MAP.keySet());
    }

    public static <I extends IAttributeId> I registerId(I id) {
        KEY_MAP.put(id.getId(), id);
        return id;
    }

    private static AttributeId createInternal(String name) {
        return Attribs.createInternal(name, 1.0);
    }

    private static AttributeId createInternal(String name, double base) {
        return Attribs.createInternal(name, base, Attribute::new);
    }

    private static AttributeId createInternal(String name, double base, AttributeId.IAttribFactory factory) {
        AttributeId id = AttributeId.create(GunsRPG.makeResource(name), base, factory);
        return Attribs.registerId(id);
    }

    private Attribs() {
    }
}

